<?php
/**
 * Customer completed order email
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/customer-completed-order.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates/Emails
 * @version     2.5.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @hooked WC_Emails::email_header() Output the email header
 */
do_action( 'woocommerce_email_header', $email_heading, $email ); ?>

<p><?php printf( __( "Hi there. Your recent order on %s has been completed. Your order details are shown below for your reference:", 'madang' ), get_option( 'blogname' ) ); ?></p>

<?php

/**
 * @hooked WC_Emails::order_details() Shows the order details table.
 * @hooked WC_Structured_Data::generate_order_data() Generates structured data.
 * @hooked WC_Structured_Data::output_structured_data() Outputs structured data.
 * @since 2.5.0
 */
do_action( 'woocommerce_email_order_details', $order, $sent_to_admin, $plain_text, $email );

/**
 * @hooked WC_Emails::order_meta() Shows order meta data.
 */
do_action( 'woocommerce_email_order_meta', $order, $sent_to_admin, $plain_text, $email );

//display nutrition calculations
if ( 1 != get_theme_mod( 'madang_email_nutrition', 0 ) ) : 

	?>

	<h2 style="color:rgb(17,17,17); font-size:18px; line-height:23.4px; margin:16px 0px 8px"><?php echo esc_html__('Nutrition Facts', 'madang'); ?></h2>
	<ul style="color:rgb(99,99,99)">
		<li style="margin-left:15px"><strong><?php echo esc_html__('Calories:', 'madang'); ?> </strong>&nbsp;<span style="color:rgb(60,60,60)"> <?php echo get_theme_mod( 'madang_calories_total', 'n/a' ); ?></span></li>
		<li style="margin-left:15px"><strong><?php echo esc_html__('Proteins:', 'madang'); ?> </strong>&nbsp;<span style="color:rgb(60,60,60)"> <?php echo get_theme_mod( 'madang_proteins_total', 'n/a' ); ?></span></li>
		<li style="margin-left:15px"><strong><?php echo esc_html__('Fats:', 'madang'); ?> </strong>&nbsp;<span style="color:rgb(60,60,60)"> <?php echo get_theme_mod( 'madang_fats_total', 'n/a' ); ?></span></li>
		<li style="margin-left:15px"><strong><?php echo esc_html__('Carbohydrates:', 'madang'); ?> </strong>&nbsp;<span style="color:rgb(60,60,60)"> <?php echo get_theme_mod( 'madang_carbohydrates_total', 'n/a' ); ?></span></li>
	</ul>

	<?php
endif;

/**
 * @hooked WC_Emails::customer_details() Shows customer details
 * @hooked WC_Emails::email_address() Shows email address
 */
do_action( 'woocommerce_email_customer_details', $order, $sent_to_admin, $plain_text, $email );

/**
 * @hooked WC_Emails::email_footer() Output the email footer
 */
do_action( 'woocommerce_email_footer', $email );
