<?php if ( ! defined( 'ABSPATH' ) ) die( 'Forbidden' );
/**
 * slider_full Shortcode
 */

$args = get_query_var('like_sc_slider_full');

$id = $class = '';
if ( !empty($args['class']) ) $class .= ' '. esc_attr($args['class']);
if ( !empty($args['id']) ) $id = ' id="'. esc_attr($args['id']). '"'; else $id = '';

$query_args = array(
	'post_type' => 'slider_full',
	'post_status' => 'publish',
	'posts_per_page' => 0,	
);

if ( !empty($args['category_filter']) ) {

	$query_args['tax_query'] = 	array(
		array(
            'taxonomy'  => 'slider_full-category',
            'field'     => 'if', 
            'terms'     => array(esc_attr($args['category_filter'])),
		)
    );
}

if ( !empty($args['items']) ) {

	$slides_out = '';
	$x = 0;
	foreach ( $args['items'] as $item ) {

		$x++;
		$image = wp_get_attachment_image_src( $item['image'], 'full' );

		$left = 100 * ($x - 1) . '%';

		$header = str_split($item['header'], 2);
		$letter = $item['header'][0];

		$colorh = $colort = $colorb = '';

		if ( !empty($item['header-color']) ) $colorh = ' style="color: '.esc_attr($item['header-color']).';"';
		if ( !empty($item['text-color']) ) $colort = ' style="color: '.esc_attr($item['text-color']).';"';
		if ( !empty($item['btn-color-custom']) ) $colorb = ' style="background-color: '.esc_attr($item['btn-color-custom']).';"';

		$slides_out .= '
			<div data-target="'.esc_attr($x).'" class="slide slide--'.esc_attr($x).'">
              <div class="slide__darkbg slide--'.esc_attr($x).'__darkbg" style="background-image: url('.esc_attr($image[0]).');"></div>
              <div class="slide__text-wrapper slide--'.esc_attr($x).'__text-wrapper">
              	<div class="slide__letter slide--'.esc_attr($x).'__letter" style="background-image: url('.esc_attr($image[0]).');">'.esc_html($letter).'</div>';

              	$c = 0;
              	foreach ( $header as $char ) {

              		$c++;
              		$slides_out .= '<div class="slide__text slide__text--'.esc_attr($c).'"'.$colorh.'>'.esc_html($char).'</div>';
              	}

              	$slides_out .= '</div>';


              	$slides_out .= '<div class="ltx-descr">';
              		$slides_out .= '<div class="ltx-descr-wrap">';
              	if ( !empty( $item['descr'])) {

              		$slides_out .= '<div class="ltx-descr-p"'.$colort.'>'.wp_kses_post($item['descr']).'</div>';
              	}

             	if ( !empty( $item['button'])) {

             		$btn_color = 'btn-main';
             		if ( !empty($item['btn-color']) ) {

             			$btn_color = 'btn-'.$item['btn-color'];
             		}

              		$slides_out .= '<br><div class="ltx-btn-wrap"><a href="'.esc_url($item['href']).'" class="btn btn-lg '.esc_attr($btn_color).'"'.$colorb.'>'.esc_html($item['button']).'</a></div>';
              	}
              		$slides_out .= '</div>';

              	$slides_out .= '</div>';

            $slides_out .= '</div>';
	}

	echo '
	<div class="ltx-fcslider-wrapper">
		<div class="ltx-slider">'.$slides_out.'
		</div>
		<div class="ltx-slider-nav"></div>
		<div data-target="right" class="ltx-side-nav ltx-side-nav--right"></div>
		<div data-target="left" class="ltx-side-nav ltx-side-nav--left"></div>
	</div>
	';	
}

/*
if ( !empty($atts['arrows']) AND $atts['arrows'] == 'enabled' ) $atts['arrows'] = true; else $atts['arrows'] = '';
if ( !empty($atts['pagination']) AND $atts['pagination'] == 'enabled' ) $atts['pagination'] = true; else $atts['pagination'] = '';

if ( !empty($atts['items']) ) {

	$cols = 3;
	if ( sizeof($atts['items']) == 3 ) $cols = 3;
	if ( sizeof($atts['items']) == 2 ) $cols = 2;
	if ( sizeof($atts['items']) == 1 ) $cols = 1;

	echo '<div class="'.esc_attr($class).'" '.$id.'>';
	echo '	<div class="ltx-slider-fc swiper-container" data-autoplay="'.esc_attr($atts['autoplay']).'" data-arrows="'.esc_attr($atts['arrows']).'" data-cols="'.esc_attr($cols).'">';
	echo '<div class="swiper-wrapper">';


	foreach ( $atts['items'] as $item ) {

		$image = wp_get_attachment_image_src( $item['image'], 'full' );
		$image_item = wp_get_attachment_image_src( $item['image_item'], 'full' );

		$item['header'] = str_replace(array('{{', '}}'), array('<span>', '</span>'), $item['header']);

		if ( !empty($image) ) {

			echo '<div class="swiper-slide">';
				echo '<a href="'.esc_url($item['href']).'" class="inner ltx-'.esc_attr($item['bg_color']).'" style="background-image: url('.$image[0].');">';

					echo '<div class="info">';

						echo '<img src="'.$image_item[0].'" class="image-item" alt="'.esc_html($item['header']).'">';

						echo '<h4>'.wp_kses_post($item['header']).'</h4>';
						if ( !empty($item['descr']) ) {
						
							echo '<p>'.esc_html($item['descr']).'</p>';
						}

						echo '<div class="hidden-div">';
							if ( !empty($item['price']) ) {

								echo '<div class="price">'.$item['price'].'</div>';
							}

							if ( !empty($args['readmore']) ) {

								echo '<span class="btn color-hover-white">'.esc_html($args['readmore']).'</span>';
							}
						echo '</div>';

					echo '</div>';
				echo '</a>';
			echo '</div>';
		}
	}

	echo '		</div>';
	if ( !empty($atts['arrows']) ) echo '<div class="swiper-arrows"><a href="#" class="arrow-left fa fa-arrow-left"></a><a href="#" class="arrow-right  fa fa-arrow-right"></a></div>';
	echo '	</div>';		
	echo '</div>';	
}

*/
