<?php if ( ! defined( 'ABSPATH' ) ) die( 'Forbidden' );
/**
 * Menu Shortcode
 */

$args = get_query_var('like_sc_menu');

$query_args = array(
	'post_type' => 'menu',
	'post_status' => 'publish',
	'posts_per_page' => 100,	
);

if ( !empty($args['ids']) ) $query_args['post__in'] = explode(',', esc_attr($args['ids']));

$cats = ltxGetMenuCats();
if ( !empty($atts['cat']) ) {

	//$cats = $cats[$atts['cat']]['child'];
	$query_args['post_parent'] = array(esc_attr($args['cat']));
}

if ( empty($args['except']) ) $args['except'] = 70;

$query = new WP_Query( $query_args );

if ( $query->have_posts() ) {

	echo '<div class="menu ltx-menu-sc ltx-filter-container ltx-menu-layout-'.esc_attr($args['layout']).'">';

		echo '<ul class="cats ltx-tabs-cats menu-filter menu-filter-'.esc_attr($args['tabs']).'">';

		while ( $query->have_posts() ) {

			$query->the_post();
			echo '<li class="ltx-cat" data-filter="'.esc_attr(get_the_ID()).'"><span class="ltx-item">'.get_the_title().'</span></li>';
		}
		echo '</ul>';

		echo '<div class="ltx-items row">';
			while ( $query->have_posts() ) {

				$query->the_post();

				$subheader = fw_get_db_post_option(get_The_ID(), 'subheader');	
				$price = fw_get_db_post_option(get_The_ID(), 'price');	
				$cut = fw_get_db_post_option(get_The_ID(), 'cut');	
				$wc_id = fw_get_db_post_option(get_The_ID(), 'wc_id');	

				$button_1_header = fw_get_db_post_option(get_The_ID(), 'order_button_header');	
				$button_1_link = fw_get_db_post_option(get_The_ID(), 'order_button_link');	
				$button_2_header = fw_get_db_post_option(get_The_ID(), 'view_button_header');	
				$button_2_link = fw_get_db_post_option(get_The_ID(), 'view_button_link');	

				$filter_cat = ' ltx-filter-item ltx-filter-id-'.get_the_ID();

				echo '<article class=" '.esc_attr($filter_cat).'">';

					echo '<div class="col-lg-6">';

						$fitmeal_image_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_The_ID()), 'full' );

						echo '<a href="'.esc_url(get_the_permalink()).'" class="ltx-photo"><img src="'.esc_url( $fitmeal_image_src[0] ).'" alt="'.esc_attr(get_the_title()).'"></a>';

					echo '</div>';
					echo '<div class="col-lg-6">';

						echo '<a href="'.esc_url(get_the_permalink()).'"><h4 class="header">'.get_the_title().'</h4></a>';
						echo '<h6 class="subheader">'.esc_html($subheader).'</h6>';
						echo '<p>'.wp_kses_post($cut).'</p>';

						echo '<h5 class="ltx-price">'.wp_kses_post(ltx_header_parse($price)).'</h5>';

						if ( !empty($button_1_header) ) {

							if ( empty( $button_1_link )) {

								$button_1_link = get_the_permalink($wc_id);
							}

							echo '<a href="'.esc_url($button_1_link).'" class="ltx-btn-first btn btn-lg btn-second color-hover-black">'.esc_html($button_1_header).'</a>';	
						}

						if ( !empty($button_2_header) ) {						

							if ( empty( $button_2_link )) {

								$button_2_link = get_the_permalink();
							}						

							echo '<a href="'.esc_url($button_2_link).'" class="ltx-btn-second btn btn-lg color-hover-black">'.esc_html($button_2_header).'</a>';
						}

					echo '</div>';
				echo '</article>';

			}

		echo '</div>';
	echo '</div>';

	wp_reset_postdata();
}

